import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Define the grid size
rows, cols = 3, 5

# Define the colors for clear and not clear tiles
clear_color = 'lightgreen'
not_clear_color = 'salmon'

# Define the robot color
robot1_color = 'white'

# Define the tile status
tile_status = {
    'tile_0-1': 'clear', 'tile_0-2': 'clear', 'tile_0-3': 'clear', 'tile_0-4': 'not clear', 'tile_0-5': 'clear',
    'tile_1-1': 'clear', 'tile_1-2': 'clear', 'tile_1-3': 'clear', 'tile_1-4': 'clear', 'tile_1-5': 'clear',
    'tile_2-1': 'clear', 'tile_2-2': 'clear', 'tile_2-3': 'clear', 'tile_2-4': 'clear', 'tile_2-5': 'clear',
}

# Define robot position
robot_position = (0, 3)

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        status = tile_status[tile_id]
        color = clear_color if status == 'clear' else not_clear_color
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='black')

# Draw the robot
row, col = robot_position
circle = patches.Circle((col + 0.5, rows-row-0.5), 0.3, edgecolor='black', facecolor=robot1_color)
ax.add_patch(circle)
ax.text(col + 0.5, rows-row-0.7, 'robot1', ha='center', va='center', fontsize=8, color='black')

# Draw available colors
color_rects = {
    'color_white': (cols + 0.5, 2),
    'color_black': (cols + 0.5, 1),
}

for color_name, (x, y) in color_rects.items():
    rect = patches.Rectangle((x, y), 0.8, 0.8, linewidth=1, edgecolor='black', facecolor=color_name.split('_')[1])
    ax.add_patch(rect)
    ax.text(x + 0.4, y + 0.4, color_name, ha='center', va='center', fontsize=8, color='black')

# Set limits and labels
ax.set_xlim(0, cols + 2)
ax.set_ylim(0, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=not_clear_color, edgecolor='black', label='Not Clear Tile'),
    patches.Patch(facecolor=robot1_color, edgecolor='black', label='Robot1 (White)'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('<PATH_REMOVED>', bbox_inches='tight')
plt.show()